<?
	/////////////////////////////////////////////////
	//                                             //
	// Foscam Pan/Tilt IP camera web interface for //
	//    RMS Boards (C)2015 EtherTek Circuits     //
	//                                             //
	/////////////////////////////////////////////////
	
	
	// Edit the three variables below to match the ip address, user name, and password of
	// your Foscam IP camera.
	$ip = "EDIT THIS";
	$user = "EDIT THIS";
	$pwd = "EDIT THIS";
	
	// Don't edit anything below this line unless you know what you are doing.
	
	
	if ($_SERVER['REQUEST_METHOD'] === 'GET') 
		{
    $AUDIO = "OFF";
		}
	
	if(isset($_POST["AUDIO_ON"]))
		{
			$AUDIO = "ON";	
		}
	if(isset($_POST["AUDIO_OFF"]))
		{
			$AUDIO = "OFF";	
		}
	
	
	$vars = file_get_contents('http://' . $ip . '/get_camera_params.cgi?user=' . $user . '&pwd=' . $pwd);
	$output = preg_split( "#(=|;)#", $vars );
	$resolution = $output[1];
	$brightness = $output[3];
	$contrast = $output[5];
	$mode = $output[7];
	$flip = $output[9];
	$fps = $output[11];
?>

<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<title>RMS IP CAMERA LIVE FEED</title>
	
		<script language="javascript"> 
			
			<?
				echo "var resolution=" . $resolution . ";";
				echo "var brightness=" . $brightness . ";";
				echo "var contrast=" . $contrast . ";";
				echo "var mode=" . $mode . ";";
				echo "var flip=" . $flip . ";";
				echo "var fps=" . $contrast . ";";
			?>
			
			var R320_240=8;
			var R640_480=32;
			var ptz_type=0;	
			var PTZ_STOP=1;
			var TILT_UP=0;
			var TILT_UP_STOP=1;
			var TILT_DOWN=2;
			var TILT_DOWN_STOP=3;
			var PAN_LEFT=6;
			var PAN_LEFT_STOP=5;
			var PAN_RIGHT=4;
			var PAN_RIGHT_STOP=7;
			var PTZ_LEFT_UP=91;
			var PTZ_RIGHT_UP=90;
			var PTZ_LEFT_DOWN=93;
			var PTZ_RIGHT_DOWN=92;
			var PTZ_CENTER=25;
			var PTZ_VPATROL=26;
			var PTZ_VPATROL_STOP=27;
			var PTZ_HPATROL=28;
			var PTZ_HPATROL_STOP=29;
			var PTZ_PELCO_D_HPATROL=20;
			var PTZ_PELCO_D_HPATROL_STOP=21;
			var IO_ON=95;
			var IO_OFF=94;
			
			function decoder_control(command)
			{
				<? echo "action_zone.location='http://" . $ip . "/decoder_control.cgi?command='+command+'&user=" . $user . "&pwd=" . $pwd . "';"; ?>
			}
			
			function ir_on()
			{
				<? echo "action_zone.location='http://" . $ip . "/decoder_control.cgi?command=95&user=" . $user . "&pwd=" . $pwd . "';"; ?>
			}
			
			function ir_off()
			{
				<? echo "action_zone.location='http://" . $ip . "/decoder_control.cgi?command=94&user=" . $user . "&pwd=" . $pwd . "';"; ?>
			}
			
			function camera_control(param,value)
			{
				<? echo "action_zone.location='http://" . $ip . "/camera_control.cgi?param='+param+'&value='+value+'&user=" . $user . "&pwd=" . $pwd . "'"; ?>
			}
			
			function set_flip()
			{
				if (image_reversal.checked)
					flip|=1;
				else
					flip&=2;
				if (image_mirror.checked)
					flip|=2;
				else
					flip&=1;	
				camera_control(5,flip);
			}
			
			function up_onmousedown() 
			{
				(flip&0x01)?decoder_control(TILT_DOWN):decoder_control(TILT_UP);
			}
			function up_onmouseup() 
			{
				if (!ptz_type)
					decoder_control(PTZ_STOP);
				else if (flip&0x01)
					decoder_control(TILT_DOWN_STOP);
				else	
					decoder_control(TILT_UP_STOP);
			}
				
			function down_onmouseover() 
			{
				down.src="images/down_down.png";
			}
			
			function down_onmouseout() 
			{
				down.src="images/down_up.png";
			}
			
			function down_onmousedown() 
			{
				
				(flip&0x01)?decoder_control(TILT_UP):decoder_control(TILT_DOWN);
			
			}
			function down_onmouseup() 
			{
				if (!ptz_type)
					decoder_control(PTZ_STOP);
				else if (flip&0x01)
					decoder_control(TILT_UP_STOP);
				else
					decoder_control(TILT_DOWN_STOP);	
			}
			function left_onmousedown() 
			{
				(flip&0x02)?decoder_control(PAN_RIGHT):decoder_control(PAN_LEFT);
			}
			function left_onmouseup() 
			{
				if (!ptz_type)
					decoder_control(PTZ_STOP);
				else if (flip&0x02)
					decoder_control(PAN_RIGHT_STOP);
				else	
					decoder_control(PAN_LEFT_STOP);	
			}
			function right_onmousedown() 
			{
				(flip&0x02)?decoder_control(PAN_LEFT):decoder_control(PAN_RIGHT);
			}
			function right_onmouseup() 
			{
				if (!ptz_type)
					decoder_control(PTZ_STOP);
				else if (flip&0x02)
					decoder_control(PAN_LEFT_STOP);
				else	
					decoder_control(PAN_RIGHT_STOP);
			}
			function leftup_onmousedown() 
			{
				if (ptz_type)
					return;
				if ((flip&0x03)==0x03)
					decoder_control(PTZ_RIGHT_DOWN);
				else if (flip&0x02)
					decoder_control(PTZ_RIGHT_UP);
				else if (flip&0x01)
					decoder_control(PTZ_LEFT_DOWN);
				else		
					decoder_control(PTZ_LEFT_UP);
			}
			function leftup_onmouseup() 
			{
				if (!ptz_type) decoder_control(PTZ_STOP);
			}
			function rightup_onmousedown() 
			{
				if (ptz_type)
					return;
				if ((flip&0x03)==0x03)
					decoder_control(PTZ_LEFT_DOWN);
				else if (flip&0x02)
					decoder_control(PTZ_LEFT_UP);
				else if (flip&0x01)
					decoder_control(PTZ_RIGHT_DOWN);
				else		
					decoder_control(PTZ_RIGHT_UP);
			}
			function rightup_onmouseup() 
			{
				if (!ptz_type) decoder_control(PTZ_STOP);
			}
			function leftdown_onmousedown() 
			{
				if (ptz_type)
					return;
				if ((flip&0x03)==0x03)
					decoder_control(PTZ_RIGHT_UP);
				else if (flip&0x02)
					decoder_control(PTZ_RIGHT_DOWN);
				else if (flip&0x01)
					decoder_control(PTZ_LEFT_UP);
				else		
					decoder_control(PTZ_LEFT_DOWN);
			}
			function leftdown_onmouseup() 
			{
				if (!ptz_type) decoder_control(PTZ_STOP);
			}
			function rightdown_onmousedown() 
			{
				if (ptz_type)
					return;
				if ((flip&0x03)==0x03)
					decoder_control(PTZ_LEFT_UP);
				else if (flip&0x02)
					decoder_control(PTZ_LEFT_DOWN);
				else if (flip&0x01)
					decoder_control(PTZ_RIGHT_UP);
				else		
					decoder_control(PTZ_RIGHT_DOWN);
			}
			function rightdown_onmouseup() 
			{
				if (!ptz_type) decoder_control(PTZ_STOP);
			}
			function center_onclick() 
			{
				if (!ptz_type) decoder_control(PTZ_CENTER);
			}
			function vpatrol_onclick() 
			{
				if (!ptz_type) decoder_control(PTZ_VPATROL);
			}
			function vpatrolstop_onclick() 
			{
				if (!ptz_type) decoder_control(PTZ_VPATROL_STOP);
			}
			function hpatrol_onclick() 
			{
				ptz_type?decoder_control(PTZ_PELCO_D_HPATROL):decoder_control(PTZ_HPATROL);
			}
			function hpatrolstop_onclick() 
			{
				ptz_type?decoder_control(PTZ_PELCO_D_HPATROL_STOP):decoder_control(PTZ_HPATROL_STOP);
			}
			
			function set_resolution()
			{
				camera_control(0,resolution_sel.value);
				setTimeout('parent.parent.main.location.reload()',2000);
			}
			function plus_brightness()
			{
				val=brightness_input.value;
				if (val++<15)
				{
					brightness_input.value=val;
					camera_control(1,val*16);
				}
			}
			function minus_brightness()
			{
				val=brightness_input.value;
				if (val-->0)
				{
					brightness_input.value=val;
					camera_control(1,val*16);
				}	
			}
			function plus_contrast()
			{
				val=contrast_input.value;
				if (val++<6)
				{
					contrast_input.value=val;
					camera_control(2,val);
				}
			}
			function minus_contrast()
			{
				val=contrast_input.value;
				if (val-->0)
				{
					contrast_input.value=val;
					camera_control(2,val);
				}
			}
			
			function open_new()
			{
				<? echo "window.open('http://" . $ip . "/snapshot.cgi?user=" . $user . "&pwd=" . $pwd . "','_blank');"; ?>
			}
			
			function body_onload()
			{
				resolution_sel.value=resolution;
				mode_sel.value=mode;
				brightness_input.value=Math.round(brightness /16);
				contrast_input.value=contrast;
				image_reversal.checked=(flip&0x01)?true:false;
				image_mirror.checked=(flip&0x02)?true:false;
			}
			
		</script>
	</head>
	<body onLoad="body_onload()">

		<table border="0" cellpadding="0" cellspacing="0" width="640" height="480" bgcolor = #C9C9C9  style="font-family:Arial">
			<tr>
				<td bgcolor="black" align="center" valign="middle">
					<?
						if($AUDIO=="ON")
						{
							echo "<iframe height='100%' width='100%' src='http://" . $ip . "/safari2.htm?user=" . $user . "&pwd=" . $pwd . "' ></iframe>";
						}
						else
						{
							echo "<img src='http://" . $ip . "/videostream.cgi?user=" . $user . "&pwd=" . $pwd . "' />";
						}
					?>
					
				</td>
			</tr>
		</table>
		
		<iframe name="action_zone" style="display:none"></iframe>
		<!-- <iframe name="action_zone"></iframe> DEBUGGING WINDOW -->
		
		<form action="foscam.php" method="POST">
			<table width="640" style="font-family:Arial" border="1" cellpadding="0" cellspacing="10" >		
				
				<tr>
					<td align="center">
						<div><img style="cursor:pointer" id="leftup" src="images/leftup_up.png" onmousedown="leftup_onmousedown()" onmouseup="leftup_onmouseup()" onmouseover="this.src=' images/leftup_down.png'" onmouseout="this.src=' images/leftup_up.png'"/><img style="cursor:pointer" id="up" src="images/up_up.png" onmousedown="up_onmousedown()" onmouseup="up_onmouseup()" onmouseover="this.src=' images/up_down.png'" onmouseout="this.src=' images/up_up.png'"/><img style="cursor:pointer" id="rightup" src="images/rightup_up.png" onmousedown="rightup_onmousedown()" onmouseup="rightup_onmouseup()" onmouseover="this.src=' images/rightup_down.png'" onmouseout="this.src=' images/rightup_up.png'"/></div>
						<div><img style="cursor:pointer" id="left" src="images/left_up.png" onmousedown="left_onmousedown()" onmouseup="left_onmouseup()"  onmouseover="this.src=' images/left_down.png'" onmouseout="this.src=' images/left_up.png'"/><img  style="cursor:pointer" id="gocenter" src="images/center_up.png" onmouseover="this.src=' images/center_down.png'" onmouseout="this.src=' images/center_up.png'" onclick="center_onclick()"/><img style="cursor:pointer" id="right" src="images/right_up.png" onmousedown="right_onmousedown()" onmouseup="right_onmouseup()"   onmouseover="this.src=' images/right_down.png'" onmouseout="this.src=' images/right_up.png'"/></div>
						<div><img style="cursor:pointer" id="leftdown" src="images/leftdown_up.png" onmousedown="leftdown_onmousedown()" onmouseup="leftdown_onmouseup()"  onmouseover="this.src=' images/leftdown_down.png'" onmouseout="this.src=' images/leftdown_up.png'"/><img  style="cursor:pointer" id="down" src="images/down_up.png" onmousedown="down_onmousedown()" onmouseup="down_onmouseup()"  onmouseover="this.src=' images/down_down.png'" onmouseout="this.src=' images/down_up.png'"/><img  style="cursor:pointer" id="rightdown" src="images/rightdown_up.png" onmousedown="rightdown_onmousedown()" onmouseup="rightdown_onmouseup()"   onmouseover="this.src=' images/rightdown_down.png'" onmouseout="this.src=' images/rightdown_up.png'"/></div>
					</td>
					<td  align="center">
						<div style="height:40px"> <img style="cursor:pointer" id="vpatrol" src="images/vpatrol_up.png" onclick="vpatrol_onclick()" onmouseover="this.src=' images/vpatrol_down.png'" onmouseout="this.src=' images/vpatrol_up.png'" /> &nbsp;<img style="cursor:pointer" id="vpatrolstop" src="images/R_stop_up.png" onclick="vpatrolstop_onclick()" onmouseover="this.src=' images/R_stop_down.png'" onmouseout="this.src=' images/R_stop_up.png'" /> </div>
						<div style="height:40px"> <img style="cursor:pointer" id="hpatrol" src="images/hpatrol_up.png" onclick="hpatrol_onclick()" onmouseover="this.src=' images/hpatrol_down.png'" onmouseout="this.src=' images/hpatrol_up.png'" /> &nbsp;<img style="cursor:pointer" id="hpatrolstop" src="images/R_stop_up.png" onclick="hpatrolstop_onclick()" onmouseover="this.src=' images/R_stop_down.png'" onmouseout="this.src=' images/R_stop_up.png'" /></div>
						<div style="height:40px"> <img style="cursor:pointer" id="switchon" src="images/switchon_up.png" onClick="decoder_control(IO_ON)" onmouseover="this.src=' images/switchon_down.png'" onmouseout="this.src=' images/switchon_up.png'" /> &nbsp;<img style="cursor:pointer" id="switchoff" src="images/switchoff_up.png"  onClick="decoder_control(IO_OFF)" onmouseover="this.src=' images/switchoff_down.png'" onmouseout="this.src=' images/switchoff_up.png'" /> </div>
					</td>
					<td  align="center">
						<input style="cursor:pointer" type="button" value="IR ON" onClick="ir_on()">
						<br>
						<br>
						<input style="cursor:pointer" type="button" value="IR OFF" onClick="ir_off()">
					</td>
					<td  align="center">
						<input id="image_reversal" type="checkbox" onClick="set_flip()">Flip
						<br>
						<br>
						<input id="image_mirror" type="checkbox" onClick="set_flip()">Mirror
					</td>
				</tr>
				
				<tr>
					<td style="text-align: center;">
						Resolution:
					</td>
					<td style="text-align: center;">
						<SELECT id="resolution_sel" onChange="set_resolution()"><OPTION value="8">320*240</OPTION><OPTION value="32">640*480</OPTION></SELECT>
					</td>
					<td style="text-align: center;">
						Mode:
					</td>
					<td style="text-align: center;">
						<SELECT id="mode_sel" onChange="camera_control(3,value)"><OPTION value="0">50 HZ</OPTION><OPTION value="1">60 HZ</OPTION><OPTION value="2">Outdoor</OPTION></SELECT>
					</td>
				</tr>
				
				<tr>
					<td style="text-align: center;">
						Brightness:
					</td>
					<td style="text-align: center;">
						<table align=center>
							<tr>
								<td><img style="cursor:pointer" src="images/minus_down.png" onClick="minus_brightness()"></td>
								<td><input style="text-align:center;" id="brightness_input" readonly maxLength="2" size="2"></td>
								<td><img style="cursor:pointer" src="images/plus_down.png" onClick="plus_brightness()"></td>					
							</tr>
						</table>
					</td>
					<td style="text-align: center;">
						Contrast:
					</td>
					<td style="text-align: center;">
						<table align=center>
							<tr>
								<td><img style="cursor:pointer" src="images/minus_down.png" onClick="minus_contrast()"></td>
								<td><input style="text-align:center;" id="contrast_input" readonly maxLength="1" size="2"></td>
								<td><img style="cursor:pointer" src="images/plus_down.png" onClick="plus_contrast()"></td>
							</tr>
						</table>
					</td>
				</tr>
				
				<tr id="tr_useaudio">
					<td style="text-align: center;" colspan="2">
						<img style="cursor:pointer" src="images/camera.jpg" onClick="open_new()">
						<br>
						<span style="cursor:pointer" onClick="open_new()"><u>Take a Snapshot</u></span>
					</td>
					<td style="text-align: center;" colspan="2">
						<input style="cursor:pointer" type="submit" value="Audio ON" name="AUDIO_ON" />
						&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
						<input style="cursor:pointer" type="submit" value="Audio OFF" name="AUDIO_OFF" />
					</td>
				</tr>
				
			</table>
		</form>
	</body>
</html>





