VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "USBisoVM DLL Example"
   ClientHeight    =   7470
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   6660
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   7470
   ScaleWidth      =   6660
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command11 
      Caption         =   "Voltmeter 6"
      Enabled         =   0   'False
      Height          =   495
      Left            =   240
      TabIndex        =   11
      Top             =   6720
      Width           =   1815
   End
   Begin VB.CommandButton Command10 
      Caption         =   "Voltmeter 5"
      Enabled         =   0   'False
      Height          =   495
      Left            =   240
      TabIndex        =   10
      Top             =   6000
      Width           =   1815
   End
   Begin VB.CommandButton Command9 
      Caption         =   "Voltmeter 4"
      Enabled         =   0   'False
      Height          =   495
      Left            =   240
      TabIndex        =   9
      Top             =   5280
      Width           =   1815
   End
   Begin VB.CommandButton Command8 
      Caption         =   "Voltmeter 3"
      Enabled         =   0   'False
      Height          =   495
      Left            =   240
      TabIndex        =   8
      Top             =   4560
      Width           =   1815
   End
   Begin VB.CommandButton Command7 
      Caption         =   "Voltmeter 2"
      Enabled         =   0   'False
      Height          =   495
      Left            =   240
      TabIndex        =   7
      Top             =   3840
      Width           =   1815
   End
   Begin VB.CommandButton Command6 
      Caption         =   "Voltmeter 1"
      Enabled         =   0   'False
      Height          =   495
      Left            =   240
      TabIndex        =   6
      Top             =   3120
      Width           =   1815
   End
   Begin VB.CommandButton Command5 
      Caption         =   "GetVersionString"
      Enabled         =   0   'False
      Height          =   375
      Left            =   240
      TabIndex        =   5
      Top             =   2520
      Width           =   1815
   End
   Begin VB.CommandButton Command4 
      Caption         =   "GetProductString"
      Enabled         =   0   'False
      Height          =   375
      Left            =   240
      TabIndex        =   4
      Top             =   1920
      Width           =   1815
   End
   Begin VB.CommandButton Command3 
      Caption         =   "GetManufacturerString"
      Enabled         =   0   'False
      Height          =   375
      Left            =   240
      TabIndex        =   3
      Top             =   1320
      Width           =   1815
   End
   Begin VB.CommandButton Command2 
      Caption         =   "FindUSBisoVMs"
      Height          =   375
      Left            =   240
      TabIndex        =   2
      Top             =   720
      Width           =   1815
   End
   Begin VB.CommandButton Command1 
      Caption         =   "TestDLL"
      Height          =   375
      Left            =   240
      TabIndex        =   1
      Top             =   120
      Width           =   1815
   End
   Begin VB.TextBox Text1 
      Height          =   7095
      Left            =   2280
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   120
      Width           =   4095
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
   
'Declare Functions in the dll. In the real world you will probably do this
'in a module. The USBisoVM_DLL.dll must be in the same folder as the Project or EXE.
'Also note that the values are being passed ByRef and ByVal.
    
Private Declare Function TestDLL Lib "USBisoVM_DLL.dll" (ByRef buffer As Byte) As Long
Private Declare Function FindUSBisoVMs Lib "USBisoVM_DLL.dll" (ByRef buffer As Byte) As Long
Private Declare Function ReadUSBisoVM Lib "USBisoVM_DLL.dll" (ByVal ID As Long, ByVal VM As Long, ByVal FORMAT As Long, ByRef buffer As Byte) As Long
Private Declare Function GetManufacturerString Lib "USBisoVM_DLL.dll" (ByVal ID As Long, ByRef buffer As Byte) As Long
Private Declare Function GetProductString Lib "USBisoVM_DLL.dll" (ByVal ID As Long, ByRef buffer As Byte) As Long
Private Declare Function GetVersionString Lib "USBisoVM_DLL.dll" (ByVal ID As Long, ByRef buffer As Byte) As Long

'Make a 1024 byte buffer that gets filled by the USBisoVM_DLL.dll
Dim buffer(1024) As Byte
'Global variable that holds the first usb isolated voltmeter board found
Dim isoVMfound As String

       
Private Sub Command1_Click()
'call the TestDLL function.
'Returns OK unless there is an error.
Dim sdbuffer As String
Dim errnum As Long
Dim xx As Integer
   
errnum = TestDLL(buffer(0))
If errnum = 0 Then
    Text1.Text = "ERROR Function Call Failed"
    Exit Sub
End If

For xx = 0 To 1023
sdbuffer = sdbuffer & Chr(buffer(xx))
Next
    
Text1.Text = Text1.Text & sdbuffer
Text1.Text = Text1.Text & vbCrLf
End Sub

Private Sub Command10_Click()
'call the ReadUSBisoVM function.
'Returns the voltage of VM5 unless there is an error.
Dim sdbuffer As String
Dim errnum As Long
Dim xx As Integer
Dim ID As Long
  
ID = CLng("&H" & isoVMfound)
errnum = ReadUSBisoVM(ID, 5, 1, buffer(0))
If errnum = 0 Then
    Text1.Text = "ERROR Function Call Failed"
    Exit Sub
End If

For xx = 0 To 1023
sdbuffer = sdbuffer & Chr(buffer(xx))
Next
    
Text1.Text = Text1.Text & sdbuffer
Text1.Text = Text1.Text & vbCrLf
End Sub

Private Sub Command11_Click()
'call the ReadUSBisoVM function.
'Returns the voltage of VM6 unless there is an error.
Dim sdbuffer As String
Dim errnum As Long
Dim xx As Integer
Dim ID As Long
  
ID = CLng("&H" & isoVMfound)
errnum = ReadUSBisoVM(ID, 6, 1, buffer(0))
If errnum = 0 Then
    Text1.Text = "ERROR Function Call Failed"
    Exit Sub
End If

For xx = 0 To 1023
sdbuffer = sdbuffer & Chr(buffer(xx))
Next
    
Text1.Text = Text1.Text & sdbuffer
Text1.Text = Text1.Text & vbCrLf
End Sub

Private Sub Command2_Click()
'call the FindUSBisoVMs function.
'Returns the list of connected isovm boards unless there is an error.
Dim sdbuffer As String
Dim errnum As Long
Dim xx As Integer
   
errnum = FindUSBisoVMs(buffer(0))
If errnum = 0 Then
    Text1.Text = "ERROR Function Call Failed"
    Exit Sub
End If

'we only use the first usb isolated voltmeter board found
For xx = 0 To 3
sdbuffer = sdbuffer & Chr(buffer(xx))
Next
    
Text1.Text = Text1.Text & sdbuffer
Text1.Text = Text1.Text & vbCrLf
isoVMfound = sdbuffer

Command3.Enabled = True
Command4.Enabled = True
Command5.Enabled = True
Command6.Enabled = True
Command7.Enabled = True
Command8.Enabled = True
Command9.Enabled = True
Command10.Enabled = True
Command11.Enabled = True

End Sub


Private Sub Command3_Click()
'call the GetManufacturerString function.
'Returns the Manufacturer String unless there is an error.
Dim sdbuffer As String
Dim errnum As Long
Dim xx As Integer
Dim ID As Long
   
ID = CLng("&H" & isoVMfound)
errnum = GetManufacturerString(ID, buffer(0))
If errnum = 0 Then
    Text1.Text = "ERROR Function Call Failed"
    Exit Sub
End If

For xx = 0 To 1023
sdbuffer = sdbuffer & Chr(buffer(xx))
Next
    
Text1.Text = Text1.Text & sdbuffer
Text1.Text = Text1.Text & vbCrLf
End Sub

Private Sub Command4_Click()
'call the GetProductString function.
'Returns the Product String unless there is an error.
Dim sdbuffer As String
Dim errnum As Long
Dim xx As Integer
Dim ID As Long
  
ID = CLng("&H" & isoVMfound)
errnum = GetProductString(ID, buffer(0))
If errnum = 0 Then
    Text1.Text = "ERROR Function Call Failed"
    Exit Sub
End If

For xx = 0 To 1023
sdbuffer = sdbuffer & Chr(buffer(xx))
Next
    
Text1.Text = Text1.Text & sdbuffer
Text1.Text = Text1.Text & vbCrLf
End Sub

Private Sub Command5_Click()
'call the GetVersionString function.
'Returns the Version String unless there is an error.
Dim sdbuffer As String
Dim errnum As Long
Dim xx As Integer
Dim ID As Long
  
ID = CLng("&H" & isoVMfound)
errnum = GetVersionString(ID, buffer(0))
If errnum = 0 Then
    Text1.Text = "ERROR Function Call Failed"
    Exit Sub
End If

For xx = 0 To 1023
sdbuffer = sdbuffer & Chr(buffer(xx))
Next
    
Text1.Text = Text1.Text & sdbuffer
Text1.Text = Text1.Text & vbCrLf
End Sub

Private Sub Command6_Click()
'call the ReadUSBisoVM function.
'Returns the voltage of VM1 unless there is an error.
Dim sdbuffer As String
Dim errnum As Long
Dim xx As Integer
Dim ID As Long
  
ID = CLng("&H" & isoVMfound)
errnum = ReadUSBisoVM(ID, 1, 1, buffer(0))
If errnum = 0 Then
    Text1.Text = "ERROR Function Call Failed"
    Exit Sub
End If

For xx = 0 To 1023
sdbuffer = sdbuffer & Chr(buffer(xx))
Next
    
Text1.Text = Text1.Text & sdbuffer
Text1.Text = Text1.Text & vbCrLf
End Sub

Private Sub Command7_Click()
'call the ReadUSBisoVM function.
'Returns the voltage of VM2 unless there is an error.
Dim sdbuffer As String
Dim errnum As Long
Dim xx As Integer
Dim ID As Long
  
ID = CLng("&H" & isoVMfound)
errnum = ReadUSBisoVM(ID, 2, 1, buffer(0))
If errnum = 0 Then
    Text1.Text = "ERROR Function Call Failed"
    Exit Sub
End If

For xx = 0 To 1023
sdbuffer = sdbuffer & Chr(buffer(xx))
Next
    
Text1.Text = Text1.Text & sdbuffer
Text1.Text = Text1.Text & vbCrLf
End Sub

Private Sub Command8_Click()
'call the ReadUSBisoVM function.
'Returns the voltage of VM3 unless there is an error.
Dim sdbuffer As String
Dim errnum As Long
Dim xx As Integer
Dim ID As Long
  
ID = CLng("&H" & isoVMfound)
errnum = ReadUSBisoVM(ID, 3, 1, buffer(0))
If errnum = 0 Then
    Text1.Text = "ERROR Function Call Failed"
    Exit Sub
End If

For xx = 0 To 1023
sdbuffer = sdbuffer & Chr(buffer(xx))
Next
    
Text1.Text = Text1.Text & sdbuffer
Text1.Text = Text1.Text & vbCrLf
End Sub

Private Sub Command9_Click()
'call the ReadUSBisoVM function.
'Returns the voltage of VM4 unless there is an error.
Dim sdbuffer As String
Dim errnum As Long
Dim xx As Integer
Dim ID As Long
  
ID = CLng("&H" & isoVMfound)
errnum = ReadUSBisoVM(ID, 4, 1, buffer(0))
If errnum = 0 Then
    Text1.Text = "ERROR Function Call Failed"
    Exit Sub
End If

For xx = 0 To 1023
sdbuffer = sdbuffer & Chr(buffer(xx))
Next
    
Text1.Text = Text1.Text & sdbuffer
Text1.Text = Text1.Text & vbCrLf
End Sub
