######################################
#                                    # 
#     USBisoVM Board Perl Example    #
# (C)opyright 2010 EtherTek Circuits #
#                                    #
######################################

#This example shows how to use Perl to read voltage readings
#from the EtherTek USB Isolated Voltmeter board.

#Reference: http://search.cpan.org/~acalpini/Win32-API-0.41/API.pm


use Win32::API;

$testBuffer = " " x 8;
$idBuffer = " " x 1024;
$manBuffer = " " x 512;
$productBuffer = " " x 512;
$versionBuffer = " " x 512;
$vm1 = " " x 32;
$vm2 = " " x 32;
$vm3 = " " x 32;
$vm4 = " " x 32;
$vm5 = " " x 32;
$vm6 = " " x 32;


$TestDLL = new Win32::API('USBisoVM_DLL.dll', 'TestDLL', 'P','I');
$FindUSBisoVMs = new Win32::API('USBisoVM_DLL.dll', 'FindUSBisoVMs', 'P','I');
$GetManufacturerString = new Win32::API('USBisoVM_DLL.dll', 'GetManufacturerString', 'IP', 'I');
$GetProductString = new Win32::API('USBisoVM_DLL.dll', 'GetProductString', 'IP', 'I');
$GetVersionString = new Win32::API('USBisoVM_DLL.dll', 'GetVersionString', 'IP', 'I');
$ReadUSBisoVM = new Win32::API('USBisoVM_DLL.dll', 'ReadUSBisoVM', 'IIIP', 'I');

 

# Test DLL connectivity
$TestDLL->Call($testBuffer);
$testBuffer =~ s/\s+$//; #remove trailing spaces
print "DLL is => " . $testBuffer . "\n";

#Get USBisoVM boards attached to system
$FindUSBisoVMs->Call($idBuffer);
$idBuffer =~ s/\s+$//; #remove trailing spaces
$ID = substr($idBuffer, 0, - 2); #strip the pipe.
print "UsbIsoVM IDs found => " . $ID . "\n";

#Get Manufacturer String
$GetManufacturerString->Call(hex $ID,$manBuffer);
$manBuffer =~ s/\s+$//; #remove trailing spaces
print "Manufacturer String => " . $manBuffer . "\n";

#Get Product String
$GetProductString->Call(hex $ID,$productBuffer);
$productBuffer =~ s/\s+$//; #remove trailing spaces
print "Product String => " . $productBuffer . "\n";

#Get Version String
$GetVersionString->Call(hex $ID,$versionBuffer);
$versionBuffer =~ s/\s+$//; #remove trailing spaces
print "Version String => " . $versionBuffer . "\n";

#Get VM1 String
$ReadUSBisoVM->Call(hex $ID,1,1,$vm1);
$vm1 =~ s/\s+$//; #remove trailing spaces
print "Voltmeter 1 => " . $vm1 . "\n";

#Get VM2 String
$ReadUSBisoVM->Call(hex $ID,2,1,$vm2);
$vm2 =~ s/\s+$//; #remove trailing spaces
print "Voltmeter 2 => " . $vm2 . "\n";

#Get VM3 String
$ReadUSBisoVM->Call(hex $ID,3,1,$vm3);
$vm3 =~ s/\s+$//; #remove trailing spaces
print "Voltmeter 3 => " . $vm3 . "\n";

#Get VM4 String
$ReadUSBisoVM->Call(hex $ID,4,1,$vm4);
$vm4 =~ s/\s+$//; #remove trailing spaces
print "Voltmeter 4 => " . $vm4 . "\n";

#Get VM5 String
$ReadUSBisoVM->Call(hex $ID,5,1,$vm5);
$vm5 =~ s/\s+$//; #remove trailing spaces
print "Voltmeter 5 => " . $vm5 . "\n";

#Get VM6 String
$ReadUSBisoVM->Call(hex $ID,6,1,$vm6);
$vm6 =~ s/\s+$//; #remove trailing spaces
print "Voltmeter 6 => " . $vm6 . "\n";

